package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait BehaviorType {
  def unwrap: software.amazon.awssdk.services.connect.model.BehaviorType
}
object BehaviorType {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.BehaviorType
  ): zio.aws.connect.model.BehaviorType = value match {
    case software.amazon.awssdk.services.connect.model.BehaviorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.BehaviorType.ROUTE_CURRENT_CHANNEL_ONLY =>
      val r = ROUTE_CURRENT_CHANNEL_ONLY
      r
    case software.amazon.awssdk.services.connect.model.BehaviorType.ROUTE_ANY_CHANNEL =>
      val r = ROUTE_ANY_CHANNEL
      r
  }
  case object unknownToSdkVersion extends zio.aws.connect.model.BehaviorType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.BehaviorType =
      software.amazon.awssdk.services.connect.model.BehaviorType.UNKNOWN_TO_SDK_VERSION
  }
  case object ROUTE_CURRENT_CHANNEL_ONLY
      extends zio.aws.connect.model.BehaviorType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.BehaviorType =
      software.amazon.awssdk.services.connect.model.BehaviorType.ROUTE_CURRENT_CHANNEL_ONLY
  }
  case object ROUTE_ANY_CHANNEL extends zio.aws.connect.model.BehaviorType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.BehaviorType =
      software.amazon.awssdk.services.connect.model.BehaviorType.ROUTE_ANY_CHANNEL
  }
}
