package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{ChatContent, ChatContentType}
import scala.jdk.CollectionConverters._
final case class ChatMessage(
    contentType: ChatContentType,
    content: ChatContent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ChatMessage = {
    import ChatMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ChatMessage
      .builder()
      .contentType(ChatContentType.unwrap(contentType): java.lang.String)
      .content(ChatContent.unwrap(content): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ChatMessage.ReadOnly =
    zio.aws.connect.model.ChatMessage.wrap(buildAwsValue())
}
object ChatMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ChatMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ChatMessage =
      zio.aws.connect.model.ChatMessage(contentType, content)
    def contentType: ChatContentType
    def content: ChatContent
    def getContentType: ZIO[Any, Nothing, ChatContentType] =
      ZIO.succeed(contentType)
    def getContent: ZIO[Any, Nothing, ChatContent] = ZIO.succeed(content)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ChatMessage
  ) extends zio.aws.connect.model.ChatMessage.ReadOnly {
    override val contentType: ChatContentType =
      zio.aws.connect.model.primitives.ChatContentType(impl.contentType())
    override val content: ChatContent =
      zio.aws.connect.model.primitives.ChatContent(impl.content())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ChatMessage
  ): zio.aws.connect.model.ChatMessage.ReadOnly = new Wrapper(impl)
}
