package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ChatParticipantRoleConfig(
    participantTimerConfigList: Iterable[
      zio.aws.connect.model.ParticipantTimerConfiguration
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ChatParticipantRoleConfig = {
    import ChatParticipantRoleConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ChatParticipantRoleConfig
      .builder()
      .participantTimerConfigList(participantTimerConfigList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ChatParticipantRoleConfig.ReadOnly =
    zio.aws.connect.model.ChatParticipantRoleConfig.wrap(buildAwsValue())
}
object ChatParticipantRoleConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ChatParticipantRoleConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ChatParticipantRoleConfig =
      zio.aws.connect.model
        .ChatParticipantRoleConfig(participantTimerConfigList.map { item =>
          item.asEditable
        })
    def participantTimerConfigList
        : List[zio.aws.connect.model.ParticipantTimerConfiguration.ReadOnly]
    def getParticipantTimerConfigList: ZIO[Any, Nothing, List[
      zio.aws.connect.model.ParticipantTimerConfiguration.ReadOnly
    ]] = ZIO.succeed(participantTimerConfigList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ChatParticipantRoleConfig
  ) extends zio.aws.connect.model.ChatParticipantRoleConfig.ReadOnly {
    override val participantTimerConfigList
        : List[zio.aws.connect.model.ParticipantTimerConfiguration.ReadOnly] =
      impl
        .participantTimerConfigList()
        .asScala
        .map { item =>
          zio.aws.connect.model.ParticipantTimerConfiguration.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ChatParticipantRoleConfig
  ): zio.aws.connect.model.ChatParticipantRoleConfig.ReadOnly = new Wrapper(
    impl
  )
}
