package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  TagValue,
  PhoneNumberId,
  PhoneNumber,
  PhoneNumberDescription,
  ARN,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class ClaimedPhoneNumberSummary(
    phoneNumberId: Optional[PhoneNumberId] = Optional.Absent,
    phoneNumberArn: Optional[ARN] = Optional.Absent,
    phoneNumber: Optional[PhoneNumber] = Optional.Absent,
    phoneNumberCountryCode: Optional[
      zio.aws.connect.model.PhoneNumberCountryCode
    ] = Optional.Absent,
    phoneNumberType: Optional[zio.aws.connect.model.PhoneNumberType] =
      Optional.Absent,
    phoneNumberDescription: Optional[PhoneNumberDescription] = Optional.Absent,
    targetArn: Optional[ARN] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    phoneNumberStatus: Optional[zio.aws.connect.model.PhoneNumberStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ClaimedPhoneNumberSummary = {
    import ClaimedPhoneNumberSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ClaimedPhoneNumberSummary
      .builder()
      .optionallyWith(
        phoneNumberId.map(value =>
          PhoneNumberId.unwrap(value): java.lang.String
        )
      )(_.phoneNumberId)
      .optionallyWith(
        phoneNumberArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.phoneNumberArn)
      .optionallyWith(
        phoneNumber.map(value => PhoneNumber.unwrap(value): java.lang.String)
      )(_.phoneNumber)
      .optionallyWith(phoneNumberCountryCode.map(value => value.unwrap))(
        _.phoneNumberCountryCode
      )
      .optionallyWith(phoneNumberType.map(value => value.unwrap))(
        _.phoneNumberType
      )
      .optionallyWith(
        phoneNumberDescription.map(value =>
          PhoneNumberDescription.unwrap(value): java.lang.String
        )
      )(_.phoneNumberDescription)
      .optionallyWith(
        targetArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.targetArn)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(phoneNumberStatus.map(value => value.buildAwsValue()))(
        _.phoneNumberStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ClaimedPhoneNumberSummary.ReadOnly =
    zio.aws.connect.model.ClaimedPhoneNumberSummary.wrap(buildAwsValue())
}
object ClaimedPhoneNumberSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ClaimedPhoneNumberSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ClaimedPhoneNumberSummary =
      zio.aws.connect.model.ClaimedPhoneNumberSummary(
        phoneNumberId.map(value => value),
        phoneNumberArn.map(value => value),
        phoneNumber.map(value => value),
        phoneNumberCountryCode.map(value => value),
        phoneNumberType.map(value => value),
        phoneNumberDescription.map(value => value),
        targetArn.map(value => value),
        tags.map(value => value),
        phoneNumberStatus.map(value => value.asEditable)
      )
    def phoneNumberId: Optional[PhoneNumberId]
    def phoneNumberArn: Optional[ARN]
    def phoneNumber: Optional[PhoneNumber]
    def phoneNumberCountryCode
        : Optional[zio.aws.connect.model.PhoneNumberCountryCode]
    def phoneNumberType: Optional[zio.aws.connect.model.PhoneNumberType]
    def phoneNumberDescription: Optional[PhoneNumberDescription]
    def targetArn: Optional[ARN]
    def tags: Optional[Map[TagKey, TagValue]]
    def phoneNumberStatus
        : Optional[zio.aws.connect.model.PhoneNumberStatus.ReadOnly]
    def getPhoneNumberId: ZIO[Any, AwsError, PhoneNumberId] =
      AwsError.unwrapOptionField("phoneNumberId", phoneNumberId)
    def getPhoneNumberArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("phoneNumberArn", phoneNumberArn)
    def getPhoneNumber: ZIO[Any, AwsError, PhoneNumber] =
      AwsError.unwrapOptionField("phoneNumber", phoneNumber)
    def getPhoneNumberCountryCode
        : ZIO[Any, AwsError, zio.aws.connect.model.PhoneNumberCountryCode] =
      AwsError.unwrapOptionField(
        "phoneNumberCountryCode",
        phoneNumberCountryCode
      )
    def getPhoneNumberType
        : ZIO[Any, AwsError, zio.aws.connect.model.PhoneNumberType] =
      AwsError.unwrapOptionField("phoneNumberType", phoneNumberType)
    def getPhoneNumberDescription: ZIO[Any, AwsError, PhoneNumberDescription] =
      AwsError.unwrapOptionField(
        "phoneNumberDescription",
        phoneNumberDescription
      )
    def getTargetArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("targetArn", targetArn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getPhoneNumberStatus
        : ZIO[Any, AwsError, zio.aws.connect.model.PhoneNumberStatus.ReadOnly] =
      AwsError.unwrapOptionField("phoneNumberStatus", phoneNumberStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ClaimedPhoneNumberSummary
  ) extends zio.aws.connect.model.ClaimedPhoneNumberSummary.ReadOnly {
    override val phoneNumberId: Optional[PhoneNumberId] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneNumberId())
      .map(value => zio.aws.connect.model.primitives.PhoneNumberId(value))
    override val phoneNumberArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneNumberArn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val phoneNumber: Optional[PhoneNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneNumber())
      .map(value => zio.aws.connect.model.primitives.PhoneNumber(value))
    override val phoneNumberCountryCode
        : Optional[zio.aws.connect.model.PhoneNumberCountryCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumberCountryCode())
        .map(value => zio.aws.connect.model.PhoneNumberCountryCode.wrap(value))
    override val phoneNumberType
        : Optional[zio.aws.connect.model.PhoneNumberType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumberType())
        .map(value => zio.aws.connect.model.PhoneNumberType.wrap(value))
    override val phoneNumberDescription: Optional[PhoneNumberDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumberDescription())
        .map(value =>
          zio.aws.connect.model.primitives.PhoneNumberDescription(value)
        )
    override val targetArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.targetArn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val phoneNumberStatus
        : Optional[zio.aws.connect.model.PhoneNumberStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumberStatus())
        .map(value => zio.aws.connect.model.PhoneNumberStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ClaimedPhoneNumberSummary
  ): zio.aws.connect.model.ClaimedPhoneNumberSummary.ReadOnly = new Wrapper(
    impl
  )
}
