package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait Comparison {
  def unwrap: software.amazon.awssdk.services.connect.model.Comparison
}
object Comparison {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.Comparison
  ): zio.aws.connect.model.Comparison = value match {
    case software.amazon.awssdk.services.connect.model.Comparison.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.Comparison.LT =>
      val r = LT
      r
  }
  case object unknownToSdkVersion extends zio.aws.connect.model.Comparison {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.Comparison =
      software.amazon.awssdk.services.connect.model.Comparison.UNKNOWN_TO_SDK_VERSION
  }
  case object LT extends zio.aws.connect.model.Comparison {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.Comparison =
      software.amazon.awssdk.services.connect.model.Comparison.LT
  }
}
