package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  ContactFlowModuleName,
  ARN,
  ContactFlowModuleId
}
import scala.jdk.CollectionConverters._
final case class ContactFlowModuleSummary(
    id: Optional[ContactFlowModuleId] = Optional.Absent,
    arn: Optional[ARN] = Optional.Absent,
    name: Optional[ContactFlowModuleName] = Optional.Absent,
    state: Optional[zio.aws.connect.model.ContactFlowModuleState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ContactFlowModuleSummary = {
    import ContactFlowModuleSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ContactFlowModuleSummary
      .builder()
      .optionallyWith(
        id.map(value => ContactFlowModuleId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        name.map(value => ContactFlowModuleName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ContactFlowModuleSummary.ReadOnly =
    zio.aws.connect.model.ContactFlowModuleSummary.wrap(buildAwsValue())
}
object ContactFlowModuleSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ContactFlowModuleSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ContactFlowModuleSummary =
      zio.aws.connect.model.ContactFlowModuleSummary(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        state.map(value => value)
      )
    def id: Optional[ContactFlowModuleId]
    def arn: Optional[ARN]
    def name: Optional[ContactFlowModuleName]
    def state: Optional[zio.aws.connect.model.ContactFlowModuleState]
    def getId: ZIO[Any, AwsError, ContactFlowModuleId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ContactFlowModuleName] =
      AwsError.unwrapOptionField("name", name)
    def getState
        : ZIO[Any, AwsError, zio.aws.connect.model.ContactFlowModuleState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ContactFlowModuleSummary
  ) extends zio.aws.connect.model.ContactFlowModuleSummary.ReadOnly {
    override val id: Optional[ContactFlowModuleId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.connect.model.primitives.ContactFlowModuleId(value))
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val name: Optional[ContactFlowModuleName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.connect.model.primitives.ContactFlowModuleName(value)
      )
    override val state: Optional[zio.aws.connect.model.ContactFlowModuleState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.connect.model.ContactFlowModuleState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ContactFlowModuleSummary
  ): zio.aws.connect.model.ContactFlowModuleSummary.ReadOnly = new Wrapper(impl)
}
