package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait ContactFlowState {
  def unwrap: software.amazon.awssdk.services.connect.model.ContactFlowState
}
object ContactFlowState {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.ContactFlowState
  ): zio.aws.connect.model.ContactFlowState = value match {
    case software.amazon.awssdk.services.connect.model.ContactFlowState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.ContactFlowState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.connect.model.ContactFlowState.ARCHIVED =>
      val r = ARCHIVED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connect.model.ContactFlowState {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactFlowState =
      software.amazon.awssdk.services.connect.model.ContactFlowState.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.connect.model.ContactFlowState {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactFlowState =
      software.amazon.awssdk.services.connect.model.ContactFlowState.ACTIVE
  }
  case object ARCHIVED extends zio.aws.connect.model.ContactFlowState {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactFlowState =
      software.amazon.awssdk.services.connect.model.ContactFlowState.ARCHIVED
  }
}
