package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ContactFlowName, ARN, ContactFlowId}
import scala.jdk.CollectionConverters._
final case class ContactFlowSummary(
    id: Optional[ContactFlowId] = Optional.Absent,
    arn: Optional[ARN] = Optional.Absent,
    name: Optional[ContactFlowName] = Optional.Absent,
    contactFlowType: Optional[zio.aws.connect.model.ContactFlowType] =
      Optional.Absent,
    contactFlowState: Optional[zio.aws.connect.model.ContactFlowState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.ContactFlowSummary = {
    import ContactFlowSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.ContactFlowSummary
      .builder()
      .optionallyWith(
        id.map(value => ContactFlowId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        name.map(value => ContactFlowName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(contactFlowType.map(value => value.unwrap))(
        _.contactFlowType
      )
      .optionallyWith(contactFlowState.map(value => value.unwrap))(
        _.contactFlowState
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.ContactFlowSummary.ReadOnly =
    zio.aws.connect.model.ContactFlowSummary.wrap(buildAwsValue())
}
object ContactFlowSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.ContactFlowSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.ContactFlowSummary =
      zio.aws.connect.model.ContactFlowSummary(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        contactFlowType.map(value => value),
        contactFlowState.map(value => value)
      )
    def id: Optional[ContactFlowId]
    def arn: Optional[ARN]
    def name: Optional[ContactFlowName]
    def contactFlowType: Optional[zio.aws.connect.model.ContactFlowType]
    def contactFlowState: Optional[zio.aws.connect.model.ContactFlowState]
    def getId: ZIO[Any, AwsError, ContactFlowId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ContactFlowName] =
      AwsError.unwrapOptionField("name", name)
    def getContactFlowType
        : ZIO[Any, AwsError, zio.aws.connect.model.ContactFlowType] =
      AwsError.unwrapOptionField("contactFlowType", contactFlowType)
    def getContactFlowState
        : ZIO[Any, AwsError, zio.aws.connect.model.ContactFlowState] =
      AwsError.unwrapOptionField("contactFlowState", contactFlowState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.ContactFlowSummary
  ) extends zio.aws.connect.model.ContactFlowSummary.ReadOnly {
    override val id: Optional[ContactFlowId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.connect.model.primitives.ContactFlowId(value))
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
    override val name: Optional[ContactFlowName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.ContactFlowName(value))
    override val contactFlowType
        : Optional[zio.aws.connect.model.ContactFlowType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contactFlowType())
        .map(value => zio.aws.connect.model.ContactFlowType.wrap(value))
    override val contactFlowState
        : Optional[zio.aws.connect.model.ContactFlowState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contactFlowState())
        .map(value => zio.aws.connect.model.ContactFlowState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.ContactFlowSummary
  ): zio.aws.connect.model.ContactFlowSummary.ReadOnly = new Wrapper(impl)
}
