package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait ContactFlowType {
  def unwrap: software.amazon.awssdk.services.connect.model.ContactFlowType
}
object ContactFlowType {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.ContactFlowType
  ): zio.aws.connect.model.ContactFlowType = value match {
    case software.amazon.awssdk.services.connect.model.ContactFlowType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.ContactFlowType.CONTACT_FLOW =>
      val r = CONTACT_FLOW
      r
    case software.amazon.awssdk.services.connect.model.ContactFlowType.CUSTOMER_QUEUE =>
      val r = CUSTOMER_QUEUE
      r
    case software.amazon.awssdk.services.connect.model.ContactFlowType.CUSTOMER_HOLD =>
      val r = CUSTOMER_HOLD
      r
    case software.amazon.awssdk.services.connect.model.ContactFlowType.CUSTOMER_WHISPER =>
      val r = CUSTOMER_WHISPER
      r
    case software.amazon.awssdk.services.connect.model.ContactFlowType.AGENT_HOLD =>
      val r = AGENT_HOLD
      r
    case software.amazon.awssdk.services.connect.model.ContactFlowType.AGENT_WHISPER =>
      val r = AGENT_WHISPER
      r
    case software.amazon.awssdk.services.connect.model.ContactFlowType.OUTBOUND_WHISPER =>
      val r = OUTBOUND_WHISPER
      r
    case software.amazon.awssdk.services.connect.model.ContactFlowType.AGENT_TRANSFER =>
      val r = AGENT_TRANSFER
      r
    case software.amazon.awssdk.services.connect.model.ContactFlowType.QUEUE_TRANSFER =>
      val r = QUEUE_TRANSFER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.connect.model.ContactFlowType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactFlowType =
      software.amazon.awssdk.services.connect.model.ContactFlowType.UNKNOWN_TO_SDK_VERSION
  }
  case object CONTACT_FLOW extends zio.aws.connect.model.ContactFlowType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactFlowType =
      software.amazon.awssdk.services.connect.model.ContactFlowType.CONTACT_FLOW
  }
  case object CUSTOMER_QUEUE extends zio.aws.connect.model.ContactFlowType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactFlowType =
      software.amazon.awssdk.services.connect.model.ContactFlowType.CUSTOMER_QUEUE
  }
  case object CUSTOMER_HOLD extends zio.aws.connect.model.ContactFlowType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactFlowType =
      software.amazon.awssdk.services.connect.model.ContactFlowType.CUSTOMER_HOLD
  }
  case object CUSTOMER_WHISPER extends zio.aws.connect.model.ContactFlowType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactFlowType =
      software.amazon.awssdk.services.connect.model.ContactFlowType.CUSTOMER_WHISPER
  }
  case object AGENT_HOLD extends zio.aws.connect.model.ContactFlowType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactFlowType =
      software.amazon.awssdk.services.connect.model.ContactFlowType.AGENT_HOLD
  }
  case object AGENT_WHISPER extends zio.aws.connect.model.ContactFlowType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactFlowType =
      software.amazon.awssdk.services.connect.model.ContactFlowType.AGENT_WHISPER
  }
  case object OUTBOUND_WHISPER extends zio.aws.connect.model.ContactFlowType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactFlowType =
      software.amazon.awssdk.services.connect.model.ContactFlowType.OUTBOUND_WHISPER
  }
  case object AGENT_TRANSFER extends zio.aws.connect.model.ContactFlowType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactFlowType =
      software.amazon.awssdk.services.connect.model.ContactFlowType.AGENT_TRANSFER
  }
  case object QUEUE_TRANSFER extends zio.aws.connect.model.ContactFlowType {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactFlowType =
      software.amazon.awssdk.services.connect.model.ContactFlowType.QUEUE_TRANSFER
  }
}
