package zio.aws.connect.model
import scala.jdk.CollectionConverters._
sealed trait ContactState {
  def unwrap: software.amazon.awssdk.services.connect.model.ContactState
}
object ContactState {
  def wrap(
      value: software.amazon.awssdk.services.connect.model.ContactState
  ): zio.aws.connect.model.ContactState = value match {
    case software.amazon.awssdk.services.connect.model.ContactState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connect.model.ContactState.INCOMING =>
      val r = INCOMING
      r
    case software.amazon.awssdk.services.connect.model.ContactState.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.connect.model.ContactState.CONNECTING =>
      val r = CONNECTING
      r
    case software.amazon.awssdk.services.connect.model.ContactState.CONNECTED =>
      val r = CONNECTED
      r
    case software.amazon.awssdk.services.connect.model.ContactState.CONNECTED_ONHOLD =>
      val r = CONNECTED_ONHOLD
      r
    case software.amazon.awssdk.services.connect.model.ContactState.MISSED =>
      val r = MISSED
      r
    case software.amazon.awssdk.services.connect.model.ContactState.ERROR =>
      val r = ERROR
      r
    case software.amazon.awssdk.services.connect.model.ContactState.ENDED =>
      val r = ENDED
      r
    case software.amazon.awssdk.services.connect.model.ContactState.REJECTED =>
      val r = REJECTED
      r
  }
  case object unknownToSdkVersion extends zio.aws.connect.model.ContactState {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactState =
      software.amazon.awssdk.services.connect.model.ContactState.UNKNOWN_TO_SDK_VERSION
  }
  case object INCOMING extends zio.aws.connect.model.ContactState {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactState =
      software.amazon.awssdk.services.connect.model.ContactState.INCOMING
  }
  case object PENDING extends zio.aws.connect.model.ContactState {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactState =
      software.amazon.awssdk.services.connect.model.ContactState.PENDING
  }
  case object CONNECTING extends zio.aws.connect.model.ContactState {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactState =
      software.amazon.awssdk.services.connect.model.ContactState.CONNECTING
  }
  case object CONNECTED extends zio.aws.connect.model.ContactState {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactState =
      software.amazon.awssdk.services.connect.model.ContactState.CONNECTED
  }
  case object CONNECTED_ONHOLD extends zio.aws.connect.model.ContactState {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactState =
      software.amazon.awssdk.services.connect.model.ContactState.CONNECTED_ONHOLD
  }
  case object MISSED extends zio.aws.connect.model.ContactState {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactState =
      software.amazon.awssdk.services.connect.model.ContactState.MISSED
  }
  case object ERROR extends zio.aws.connect.model.ContactState {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactState =
      software.amazon.awssdk.services.connect.model.ContactState.ERROR
  }
  case object ENDED extends zio.aws.connect.model.ContactState {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactState =
      software.amazon.awssdk.services.connect.model.ContactState.ENDED
  }
  case object REJECTED extends zio.aws.connect.model.ContactState {
    override def unwrap
        : software.amazon.awssdk.services.connect.model.ContactState =
      software.amazon.awssdk.services.connect.model.ContactState.REJECTED
  }
}
