package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  ContactFlowModuleName,
  ContactFlowModuleDescription,
  InstanceId,
  TagValue,
  ContactFlowModuleContent,
  ClientToken,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateContactFlowModuleRequest(
    instanceId: InstanceId,
    name: ContactFlowModuleName,
    description: Optional[ContactFlowModuleDescription] = Optional.Absent,
    content: ContactFlowModuleContent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateContactFlowModuleRequest = {
    import CreateContactFlowModuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateContactFlowModuleRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .name(ContactFlowModuleName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ContactFlowModuleDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .content(ContactFlowModuleContent.unwrap(content): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.CreateContactFlowModuleRequest.ReadOnly =
    zio.aws.connect.model.CreateContactFlowModuleRequest.wrap(buildAwsValue())
}
object CreateContactFlowModuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateContactFlowModuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateContactFlowModuleRequest =
      zio.aws.connect.model.CreateContactFlowModuleRequest(
        instanceId,
        name,
        description.map(value => value),
        content,
        tags.map(value => value),
        clientToken.map(value => value)
      )
    def instanceId: InstanceId
    def name: ContactFlowModuleName
    def description: Optional[ContactFlowModuleDescription]
    def content: ContactFlowModuleContent
    def tags: Optional[Map[TagKey, TagValue]]
    def clientToken: Optional[ClientToken]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getName: ZIO[Any, Nothing, ContactFlowModuleName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, ContactFlowModuleDescription] =
      AwsError.unwrapOptionField("description", description)
    def getContent: ZIO[Any, Nothing, ContactFlowModuleContent] =
      ZIO.succeed(content)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateContactFlowModuleRequest
  ) extends zio.aws.connect.model.CreateContactFlowModuleRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val name: ContactFlowModuleName =
      zio.aws.connect.model.primitives.ContactFlowModuleName(impl.name())
    override val description: Optional[ContactFlowModuleDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.connect.model.primitives.ContactFlowModuleDescription(value)
        )
    override val content: ContactFlowModuleContent =
      zio.aws.connect.model.primitives.ContactFlowModuleContent(impl.content())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.connect.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateContactFlowModuleRequest
  ): zio.aws.connect.model.CreateContactFlowModuleRequest.ReadOnly =
    new Wrapper(impl)
}
