package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ARN, ContactFlowModuleId}
import scala.jdk.CollectionConverters._
final case class CreateContactFlowModuleResponse(
    id: Optional[ContactFlowModuleId] = Optional.Absent,
    arn: Optional[ARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateContactFlowModuleResponse = {
    import CreateContactFlowModuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateContactFlowModuleResponse
      .builder()
      .optionallyWith(
        id.map(value => ContactFlowModuleId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => ARN.unwrap(value): java.lang.String))(
        _.arn
      )
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.CreateContactFlowModuleResponse.ReadOnly =
    zio.aws.connect.model.CreateContactFlowModuleResponse.wrap(buildAwsValue())
}
object CreateContactFlowModuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateContactFlowModuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateContactFlowModuleResponse =
      zio.aws.connect.model.CreateContactFlowModuleResponse(
        id.map(value => value),
        arn.map(value => value)
      )
    def id: Optional[ContactFlowModuleId]
    def arn: Optional[ARN]
    def getId: ZIO[Any, AwsError, ContactFlowModuleId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ARN] = AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateContactFlowModuleResponse
  ) extends zio.aws.connect.model.CreateContactFlowModuleResponse.ReadOnly {
    override val id: Optional[ContactFlowModuleId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.connect.model.primitives.ContactFlowModuleId(value))
    override val arn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateContactFlowModuleResponse
  ): zio.aws.connect.model.CreateContactFlowModuleResponse.ReadOnly =
    new Wrapper(impl)
}
