package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  ClientToken,
  EvaluationFormDescription,
  EvaluationFormTitle,
  InstanceId
}
import scala.jdk.CollectionConverters._
final case class CreateEvaluationFormRequest(
    instanceId: InstanceId,
    title: EvaluationFormTitle,
    description: Optional[EvaluationFormDescription] = Optional.Absent,
    items: Iterable[zio.aws.connect.model.EvaluationFormItem],
    scoringStrategy: Optional[
      zio.aws.connect.model.EvaluationFormScoringStrategy
    ] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateEvaluationFormRequest = {
    import CreateEvaluationFormRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateEvaluationFormRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .title(EvaluationFormTitle.unwrap(title): java.lang.String)
      .optionallyWith(
        description.map(value =>
          EvaluationFormDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(scoringStrategy.map(value => value.buildAwsValue()))(
        _.scoringStrategy
      )
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateEvaluationFormRequest.ReadOnly =
    zio.aws.connect.model.CreateEvaluationFormRequest.wrap(buildAwsValue())
}
object CreateEvaluationFormRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateEvaluationFormRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateEvaluationFormRequest =
      zio.aws.connect.model.CreateEvaluationFormRequest(
        instanceId,
        title,
        description.map(value => value),
        items.map { item =>
          item.asEditable
        },
        scoringStrategy.map(value => value.asEditable),
        clientToken.map(value => value)
      )
    def instanceId: InstanceId
    def title: EvaluationFormTitle
    def description: Optional[EvaluationFormDescription]
    def items: List[zio.aws.connect.model.EvaluationFormItem.ReadOnly]
    def scoringStrategy
        : Optional[zio.aws.connect.model.EvaluationFormScoringStrategy.ReadOnly]
    def clientToken: Optional[ClientToken]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getTitle: ZIO[Any, Nothing, EvaluationFormTitle] = ZIO.succeed(title)
    def getDescription: ZIO[Any, AwsError, EvaluationFormDescription] =
      AwsError.unwrapOptionField("description", description)
    def getItems: ZIO[Any, Nothing, List[
      zio.aws.connect.model.EvaluationFormItem.ReadOnly
    ]] = ZIO.succeed(items)
    def getScoringStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.EvaluationFormScoringStrategy.ReadOnly
    ] = AwsError.unwrapOptionField("scoringStrategy", scoringStrategy)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateEvaluationFormRequest
  ) extends zio.aws.connect.model.CreateEvaluationFormRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val title: EvaluationFormTitle =
      zio.aws.connect.model.primitives.EvaluationFormTitle(impl.title())
    override val description: Optional[EvaluationFormDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.connect.model.primitives.EvaluationFormDescription(value)
        )
    override val items
        : List[zio.aws.connect.model.EvaluationFormItem.ReadOnly] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.connect.model.EvaluationFormItem.wrap(item)
      }
      .toList
    override val scoringStrategy: Optional[
      zio.aws.connect.model.EvaluationFormScoringStrategy.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scoringStrategy())
      .map(value =>
        zio.aws.connect.model.EvaluationFormScoringStrategy.wrap(value)
      )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.connect.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateEvaluationFormRequest
  ): zio.aws.connect.model.CreateEvaluationFormRequest.ReadOnly = new Wrapper(
    impl
  )
}
