package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{ARN, ResourceId}
import scala.jdk.CollectionConverters._
final case class CreateEvaluationFormResponse(
    evaluationFormId: ResourceId,
    evaluationFormArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateEvaluationFormResponse = {
    import CreateEvaluationFormResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateEvaluationFormResponse
      .builder()
      .evaluationFormId(ResourceId.unwrap(evaluationFormId): java.lang.String)
      .evaluationFormArn(ARN.unwrap(evaluationFormArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateEvaluationFormResponse.ReadOnly =
    zio.aws.connect.model.CreateEvaluationFormResponse.wrap(buildAwsValue())
}
object CreateEvaluationFormResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateEvaluationFormResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateEvaluationFormResponse =
      zio.aws.connect.model
        .CreateEvaluationFormResponse(evaluationFormId, evaluationFormArn)
    def evaluationFormId: ResourceId
    def evaluationFormArn: ARN
    def getEvaluationFormId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(evaluationFormId)
    def getEvaluationFormArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(evaluationFormArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateEvaluationFormResponse
  ) extends zio.aws.connect.model.CreateEvaluationFormResponse.ReadOnly {
    override val evaluationFormId: ResourceId =
      zio.aws.connect.model.primitives.ResourceId(impl.evaluationFormId())
    override val evaluationFormArn: ARN =
      zio.aws.connect.model.primitives.ARN(impl.evaluationFormArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateEvaluationFormResponse
  ): zio.aws.connect.model.CreateEvaluationFormResponse.ReadOnly = new Wrapper(
    impl
  )
}
