package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  SourceApplicationName,
  InstanceId,
  TagValue,
  URI,
  ARN,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateIntegrationAssociationRequest(
    instanceId: InstanceId,
    integrationType: zio.aws.connect.model.IntegrationType,
    integrationArn: ARN,
    sourceApplicationUrl: Optional[URI] = Optional.Absent,
    sourceApplicationName: Optional[SourceApplicationName] = Optional.Absent,
    sourceType: Optional[zio.aws.connect.model.SourceType] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateIntegrationAssociationRequest = {
    import CreateIntegrationAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateIntegrationAssociationRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .integrationType(integrationType.unwrap)
      .integrationArn(ARN.unwrap(integrationArn): java.lang.String)
      .optionallyWith(
        sourceApplicationUrl.map(value => URI.unwrap(value): java.lang.String)
      )(_.sourceApplicationUrl)
      .optionallyWith(
        sourceApplicationName.map(value =>
          SourceApplicationName.unwrap(value): java.lang.String
        )
      )(_.sourceApplicationName)
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.CreateIntegrationAssociationRequest.ReadOnly =
    zio.aws.connect.model.CreateIntegrationAssociationRequest
      .wrap(buildAwsValue())
}
object CreateIntegrationAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateIntegrationAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateIntegrationAssociationRequest =
      zio.aws.connect.model.CreateIntegrationAssociationRequest(
        instanceId,
        integrationType,
        integrationArn,
        sourceApplicationUrl.map(value => value),
        sourceApplicationName.map(value => value),
        sourceType.map(value => value),
        tags.map(value => value)
      )
    def instanceId: InstanceId
    def integrationType: zio.aws.connect.model.IntegrationType
    def integrationArn: ARN
    def sourceApplicationUrl: Optional[URI]
    def sourceApplicationName: Optional[SourceApplicationName]
    def sourceType: Optional[zio.aws.connect.model.SourceType]
    def tags: Optional[Map[TagKey, TagValue]]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getIntegrationType
        : ZIO[Any, Nothing, zio.aws.connect.model.IntegrationType] =
      ZIO.succeed(integrationType)
    def getIntegrationArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(integrationArn)
    def getSourceApplicationUrl: ZIO[Any, AwsError, URI] =
      AwsError.unwrapOptionField("sourceApplicationUrl", sourceApplicationUrl)
    def getSourceApplicationName: ZIO[Any, AwsError, SourceApplicationName] =
      AwsError.unwrapOptionField("sourceApplicationName", sourceApplicationName)
    def getSourceType: ZIO[Any, AwsError, zio.aws.connect.model.SourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateIntegrationAssociationRequest
  ) extends zio.aws.connect.model.CreateIntegrationAssociationRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val integrationType: zio.aws.connect.model.IntegrationType =
      zio.aws.connect.model.IntegrationType.wrap(impl.integrationType())
    override val integrationArn: ARN =
      zio.aws.connect.model.primitives.ARN(impl.integrationArn())
    override val sourceApplicationUrl: Optional[URI] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceApplicationUrl())
      .map(value => zio.aws.connect.model.primitives.URI(value))
    override val sourceApplicationName: Optional[SourceApplicationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceApplicationName())
        .map(value =>
          zio.aws.connect.model.primitives.SourceApplicationName(value)
        )
    override val sourceType: Optional[zio.aws.connect.model.SourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceType())
        .map(value => zio.aws.connect.model.SourceType.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateIntegrationAssociationRequest
  ): zio.aws.connect.model.CreateIntegrationAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
