package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ClientToken, ContactId, InstanceId}
import scala.jdk.CollectionConverters._
final case class CreateParticipantRequest(
    instanceId: InstanceId,
    contactId: ContactId,
    clientToken: Optional[ClientToken] = Optional.Absent,
    participantDetails: zio.aws.connect.model.ParticipantDetailsToAdd
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateParticipantRequest = {
    import CreateParticipantRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateParticipantRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .contactId(ContactId.unwrap(contactId): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .participantDetails(participantDetails.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateParticipantRequest.ReadOnly =
    zio.aws.connect.model.CreateParticipantRequest.wrap(buildAwsValue())
}
object CreateParticipantRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateParticipantRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateParticipantRequest =
      zio.aws.connect.model.CreateParticipantRequest(
        instanceId,
        contactId,
        clientToken.map(value => value),
        participantDetails.asEditable
      )
    def instanceId: InstanceId
    def contactId: ContactId
    def clientToken: Optional[ClientToken]
    def participantDetails
        : zio.aws.connect.model.ParticipantDetailsToAdd.ReadOnly
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getContactId: ZIO[Any, Nothing, ContactId] = ZIO.succeed(contactId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getParticipantDetails: ZIO[
      Any,
      Nothing,
      zio.aws.connect.model.ParticipantDetailsToAdd.ReadOnly
    ] = ZIO.succeed(participantDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateParticipantRequest
  ) extends zio.aws.connect.model.CreateParticipantRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val contactId: ContactId =
      zio.aws.connect.model.primitives.ContactId(impl.contactId())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.connect.model.primitives.ClientToken(value))
    override val participantDetails
        : zio.aws.connect.model.ParticipantDetailsToAdd.ReadOnly =
      zio.aws.connect.model.ParticipantDetailsToAdd
        .wrap(impl.participantDetails())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateParticipantRequest
  ): zio.aws.connect.model.CreateParticipantRequest.ReadOnly = new Wrapper(impl)
}
