package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.ParticipantId
import scala.jdk.CollectionConverters._
final case class CreateParticipantResponse(
    participantCredentials: Optional[
      zio.aws.connect.model.ParticipantTokenCredentials
    ] = Optional.Absent,
    participantId: Optional[ParticipantId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateParticipantResponse = {
    import CreateParticipantResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateParticipantResponse
      .builder()
      .optionallyWith(
        participantCredentials.map(value => value.buildAwsValue())
      )(_.participantCredentials)
      .optionallyWith(
        participantId.map(value =>
          ParticipantId.unwrap(value): java.lang.String
        )
      )(_.participantId)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateParticipantResponse.ReadOnly =
    zio.aws.connect.model.CreateParticipantResponse.wrap(buildAwsValue())
}
object CreateParticipantResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateParticipantResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateParticipantResponse =
      zio.aws.connect.model.CreateParticipantResponse(
        participantCredentials.map(value => value.asEditable),
        participantId.map(value => value)
      )
    def participantCredentials
        : Optional[zio.aws.connect.model.ParticipantTokenCredentials.ReadOnly]
    def participantId: Optional[ParticipantId]
    def getParticipantCredentials: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.ParticipantTokenCredentials.ReadOnly
    ] = AwsError.unwrapOptionField(
      "participantCredentials",
      participantCredentials
    )
    def getParticipantId: ZIO[Any, AwsError, ParticipantId] =
      AwsError.unwrapOptionField("participantId", participantId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateParticipantResponse
  ) extends zio.aws.connect.model.CreateParticipantResponse.ReadOnly {
    override val participantCredentials
        : Optional[zio.aws.connect.model.ParticipantTokenCredentials.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.participantCredentials())
        .map(value =>
          zio.aws.connect.model.ParticipantTokenCredentials.wrap(value)
        )
    override val participantId: Optional[ParticipantId] = zio.aws.core.internal
      .optionalFromNullable(impl.participantId())
      .map(value => zio.aws.connect.model.primitives.ParticipantId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateParticipantResponse
  ): zio.aws.connect.model.CreateParticipantResponse.ReadOnly = new Wrapper(
    impl
  )
}
