package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  S3Uri,
  InstanceId,
  TagValue,
  CommonNameLength127,
  PromptDescription,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreatePromptRequest(
    instanceId: InstanceId,
    name: CommonNameLength127,
    description: Optional[PromptDescription] = Optional.Absent,
    s3Uri: S3Uri,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreatePromptRequest = {
    import CreatePromptRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreatePromptRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .name(CommonNameLength127.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          PromptDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreatePromptRequest.ReadOnly =
    zio.aws.connect.model.CreatePromptRequest.wrap(buildAwsValue())
}
object CreatePromptRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreatePromptRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreatePromptRequest =
      zio.aws.connect.model.CreatePromptRequest(
        instanceId,
        name,
        description.map(value => value),
        s3Uri,
        tags.map(value => value)
      )
    def instanceId: InstanceId
    def name: CommonNameLength127
    def description: Optional[PromptDescription]
    def s3Uri: S3Uri
    def tags: Optional[Map[TagKey, TagValue]]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getName: ZIO[Any, Nothing, CommonNameLength127] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, PromptDescription] =
      AwsError.unwrapOptionField("description", description)
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreatePromptRequest
  ) extends zio.aws.connect.model.CreatePromptRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val name: CommonNameLength127 =
      zio.aws.connect.model.primitives.CommonNameLength127(impl.name())
    override val description: Optional[PromptDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.connect.model.primitives.PromptDescription(value))
    override val s3Uri: S3Uri =
      zio.aws.connect.model.primitives.S3Uri(impl.s3Uri())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreatePromptRequest
  ): zio.aws.connect.model.CreatePromptRequest.ReadOnly = new Wrapper(impl)
}
