package zio.aws.connect.model
import zio.aws.connect.model.primitives.{
  QuickConnectId,
  HoursOfOperationId,
  InstanceId,
  TagValue,
  QueueMaxContacts,
  CommonNameLength127,
  QueueDescription,
  TagKey
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateQueueRequest(
    instanceId: InstanceId,
    name: CommonNameLength127,
    description: Optional[QueueDescription] = Optional.Absent,
    outboundCallerConfig: Optional[zio.aws.connect.model.OutboundCallerConfig] =
      Optional.Absent,
    hoursOfOperationId: HoursOfOperationId,
    maxContacts: Optional[QueueMaxContacts] = Optional.Absent,
    quickConnectIds: Optional[Iterable[QuickConnectId]] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateQueueRequest = {
    import CreateQueueRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateQueueRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .name(CommonNameLength127.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          QueueDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(outboundCallerConfig.map(value => value.buildAwsValue()))(
        _.outboundCallerConfig
      )
      .hoursOfOperationId(
        HoursOfOperationId.unwrap(hoursOfOperationId): java.lang.String
      )
      .optionallyWith(
        maxContacts.map(value => QueueMaxContacts.unwrap(value): Integer)
      )(_.maxContacts)
      .optionallyWith(
        quickConnectIds.map(value =>
          value.map { item =>
            QuickConnectId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.quickConnectIds)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateQueueRequest.ReadOnly =
    zio.aws.connect.model.CreateQueueRequest.wrap(buildAwsValue())
}
object CreateQueueRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateQueueRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateQueueRequest =
      zio.aws.connect.model.CreateQueueRequest(
        instanceId,
        name,
        description.map(value => value),
        outboundCallerConfig.map(value => value.asEditable),
        hoursOfOperationId,
        maxContacts.map(value => value),
        quickConnectIds.map(value => value),
        tags.map(value => value)
      )
    def instanceId: InstanceId
    def name: CommonNameLength127
    def description: Optional[QueueDescription]
    def outboundCallerConfig
        : Optional[zio.aws.connect.model.OutboundCallerConfig.ReadOnly]
    def hoursOfOperationId: HoursOfOperationId
    def maxContacts: Optional[QueueMaxContacts]
    def quickConnectIds: Optional[List[QuickConnectId]]
    def tags: Optional[Map[TagKey, TagValue]]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getName: ZIO[Any, Nothing, CommonNameLength127] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, QueueDescription] =
      AwsError.unwrapOptionField("description", description)
    def getOutboundCallerConfig: ZIO[
      Any,
      AwsError,
      zio.aws.connect.model.OutboundCallerConfig.ReadOnly
    ] = AwsError.unwrapOptionField("outboundCallerConfig", outboundCallerConfig)
    def getHoursOfOperationId: ZIO[Any, Nothing, HoursOfOperationId] =
      ZIO.succeed(hoursOfOperationId)
    def getMaxContacts: ZIO[Any, AwsError, QueueMaxContacts] =
      AwsError.unwrapOptionField("maxContacts", maxContacts)
    def getQuickConnectIds: ZIO[Any, AwsError, List[QuickConnectId]] =
      AwsError.unwrapOptionField("quickConnectIds", quickConnectIds)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateQueueRequest
  ) extends zio.aws.connect.model.CreateQueueRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val name: CommonNameLength127 =
      zio.aws.connect.model.primitives.CommonNameLength127(impl.name())
    override val description: Optional[QueueDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.connect.model.primitives.QueueDescription(value))
    override val outboundCallerConfig
        : Optional[zio.aws.connect.model.OutboundCallerConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outboundCallerConfig())
        .map(value => zio.aws.connect.model.OutboundCallerConfig.wrap(value))
    override val hoursOfOperationId: HoursOfOperationId =
      zio.aws.connect.model.primitives
        .HoursOfOperationId(impl.hoursOfOperationId())
    override val maxContacts: Optional[QueueMaxContacts] = zio.aws.core.internal
      .optionalFromNullable(impl.maxContacts())
      .map(value => zio.aws.connect.model.primitives.QueueMaxContacts(value))
    override val quickConnectIds: Optional[List[QuickConnectId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.quickConnectIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.primitives.QuickConnectId(item)
          }.toList
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateQueueRequest
  ): zio.aws.connect.model.CreateQueueRequest.ReadOnly = new Wrapper(impl)
}
