package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  QueueId,
  InstanceId,
  TagValue,
  RoutingProfileName,
  RoutingProfileDescription,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateRoutingProfileRequest(
    instanceId: InstanceId,
    name: RoutingProfileName,
    description: RoutingProfileDescription,
    defaultOutboundQueueId: QueueId,
    queueConfigs: Optional[
      Iterable[zio.aws.connect.model.RoutingProfileQueueConfig]
    ] = Optional.Absent,
    mediaConcurrencies: Iterable[zio.aws.connect.model.MediaConcurrency],
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    agentAvailabilityTimer: Optional[
      zio.aws.connect.model.AgentAvailabilityTimer
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateRoutingProfileRequest = {
    import CreateRoutingProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateRoutingProfileRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .name(RoutingProfileName.unwrap(name): java.lang.String)
      .description(
        RoutingProfileDescription.unwrap(description): java.lang.String
      )
      .defaultOutboundQueueId(
        QueueId.unwrap(defaultOutboundQueueId): java.lang.String
      )
      .optionallyWith(
        queueConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.queueConfigs)
      .mediaConcurrencies(mediaConcurrencies.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(agentAvailabilityTimer.map(value => value.unwrap))(
        _.agentAvailabilityTimer
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateRoutingProfileRequest.ReadOnly =
    zio.aws.connect.model.CreateRoutingProfileRequest.wrap(buildAwsValue())
}
object CreateRoutingProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateRoutingProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateRoutingProfileRequest =
      zio.aws.connect.model.CreateRoutingProfileRequest(
        instanceId,
        name,
        description,
        defaultOutboundQueueId,
        queueConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        mediaConcurrencies.map { item =>
          item.asEditable
        },
        tags.map(value => value),
        agentAvailabilityTimer.map(value => value)
      )
    def instanceId: InstanceId
    def name: RoutingProfileName
    def description: RoutingProfileDescription
    def defaultOutboundQueueId: QueueId
    def queueConfigs: Optional[
      List[zio.aws.connect.model.RoutingProfileQueueConfig.ReadOnly]
    ]
    def mediaConcurrencies
        : List[zio.aws.connect.model.MediaConcurrency.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def agentAvailabilityTimer
        : Optional[zio.aws.connect.model.AgentAvailabilityTimer]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getName: ZIO[Any, Nothing, RoutingProfileName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, Nothing, RoutingProfileDescription] =
      ZIO.succeed(description)
    def getDefaultOutboundQueueId: ZIO[Any, Nothing, QueueId] =
      ZIO.succeed(defaultOutboundQueueId)
    def getQueueConfigs: ZIO[Any, AwsError, List[
      zio.aws.connect.model.RoutingProfileQueueConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("queueConfigs", queueConfigs)
    def getMediaConcurrencies: ZIO[Any, Nothing, List[
      zio.aws.connect.model.MediaConcurrency.ReadOnly
    ]] = ZIO.succeed(mediaConcurrencies)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAgentAvailabilityTimer
        : ZIO[Any, AwsError, zio.aws.connect.model.AgentAvailabilityTimer] =
      AwsError.unwrapOptionField(
        "agentAvailabilityTimer",
        agentAvailabilityTimer
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateRoutingProfileRequest
  ) extends zio.aws.connect.model.CreateRoutingProfileRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val name: RoutingProfileName =
      zio.aws.connect.model.primitives.RoutingProfileName(impl.name())
    override val description: RoutingProfileDescription =
      zio.aws.connect.model.primitives
        .RoutingProfileDescription(impl.description())
    override val defaultOutboundQueueId: QueueId =
      zio.aws.connect.model.primitives.QueueId(impl.defaultOutboundQueueId())
    override val queueConfigs: Optional[
      List[zio.aws.connect.model.RoutingProfileQueueConfig.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.queueConfigs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.RoutingProfileQueueConfig.wrap(item)
        }.toList
      )
    override val mediaConcurrencies
        : List[zio.aws.connect.model.MediaConcurrency.ReadOnly] = impl
      .mediaConcurrencies()
      .asScala
      .map { item =>
        zio.aws.connect.model.MediaConcurrency.wrap(item)
      }
      .toList
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val agentAvailabilityTimer
        : Optional[zio.aws.connect.model.AgentAvailabilityTimer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.agentAvailabilityTimer())
        .map(value => zio.aws.connect.model.AgentAvailabilityTimer.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateRoutingProfileRequest
  ): zio.aws.connect.model.CreateRoutingProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
