package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  ClientToken,
  RuleFunction,
  RuleName,
  InstanceId
}
import scala.jdk.CollectionConverters._
final case class CreateRuleRequest(
    instanceId: InstanceId,
    name: RuleName,
    triggerEventSource: zio.aws.connect.model.RuleTriggerEventSource,
    function: RuleFunction,
    actions: Iterable[zio.aws.connect.model.RuleAction],
    publishStatus: zio.aws.connect.model.RulePublishStatus,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateRuleRequest = {
    import CreateRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateRuleRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .name(RuleName.unwrap(name): java.lang.String)
      .triggerEventSource(triggerEventSource.buildAwsValue())
      .function(RuleFunction.unwrap(function): java.lang.String)
      .actions(actions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .publishStatus(publishStatus.unwrap)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateRuleRequest.ReadOnly =
    zio.aws.connect.model.CreateRuleRequest.wrap(buildAwsValue())
}
object CreateRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateRuleRequest =
      zio.aws.connect.model.CreateRuleRequest(
        instanceId,
        name,
        triggerEventSource.asEditable,
        function,
        actions.map { item =>
          item.asEditable
        },
        publishStatus,
        clientToken.map(value => value)
      )
    def instanceId: InstanceId
    def name: RuleName
    def triggerEventSource
        : zio.aws.connect.model.RuleTriggerEventSource.ReadOnly
    def function: RuleFunction
    def actions: List[zio.aws.connect.model.RuleAction.ReadOnly]
    def publishStatus: zio.aws.connect.model.RulePublishStatus
    def clientToken: Optional[ClientToken]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getName: ZIO[Any, Nothing, RuleName] = ZIO.succeed(name)
    def getTriggerEventSource: ZIO[
      Any,
      Nothing,
      zio.aws.connect.model.RuleTriggerEventSource.ReadOnly
    ] = ZIO.succeed(triggerEventSource)
    def getFunction: ZIO[Any, Nothing, RuleFunction] = ZIO.succeed(function)
    def getActions
        : ZIO[Any, Nothing, List[zio.aws.connect.model.RuleAction.ReadOnly]] =
      ZIO.succeed(actions)
    def getPublishStatus
        : ZIO[Any, Nothing, zio.aws.connect.model.RulePublishStatus] =
      ZIO.succeed(publishStatus)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateRuleRequest
  ) extends zio.aws.connect.model.CreateRuleRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val name: RuleName =
      zio.aws.connect.model.primitives.RuleName(impl.name())
    override val triggerEventSource
        : zio.aws.connect.model.RuleTriggerEventSource.ReadOnly =
      zio.aws.connect.model.RuleTriggerEventSource
        .wrap(impl.triggerEventSource())
    override val function: RuleFunction =
      zio.aws.connect.model.primitives.RuleFunction(impl.function())
    override val actions: List[zio.aws.connect.model.RuleAction.ReadOnly] = impl
      .actions()
      .asScala
      .map { item =>
        zio.aws.connect.model.RuleAction.wrap(item)
      }
      .toList
    override val publishStatus: zio.aws.connect.model.RulePublishStatus =
      zio.aws.connect.model.RulePublishStatus.wrap(impl.publishStatus())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.connect.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateRuleRequest
  ): zio.aws.connect.model.CreateRuleRequest.ReadOnly = new Wrapper(impl)
}
