package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{RuleId, ARN}
import scala.jdk.CollectionConverters._
final case class CreateRuleResponse(ruleArn: ARN, ruleId: RuleId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateRuleResponse = {
    import CreateRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateRuleResponse
      .builder()
      .ruleArn(ARN.unwrap(ruleArn): java.lang.String)
      .ruleId(RuleId.unwrap(ruleId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateRuleResponse.ReadOnly =
    zio.aws.connect.model.CreateRuleResponse.wrap(buildAwsValue())
}
object CreateRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateRuleResponse =
      zio.aws.connect.model.CreateRuleResponse(ruleArn, ruleId)
    def ruleArn: ARN
    def ruleId: RuleId
    def getRuleArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(ruleArn)
    def getRuleId: ZIO[Any, Nothing, RuleId] = ZIO.succeed(ruleId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateRuleResponse
  ) extends zio.aws.connect.model.CreateRuleResponse.ReadOnly {
    override val ruleArn: ARN =
      zio.aws.connect.model.primitives.ARN(impl.ruleArn())
    override val ruleId: RuleId =
      zio.aws.connect.model.primitives.RuleId(impl.ruleId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateRuleResponse
  ): zio.aws.connect.model.CreateRuleResponse.ReadOnly = new Wrapper(impl)
}
