package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  CreateSecurityProfileName,
  SecurityProfilePolicyValue,
  SecurityProfilePolicyKey,
  SecurityProfileDescription,
  SecurityProfilePermission,
  InstanceId,
  TagValue,
  TagRestrictedResourceName,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateSecurityProfileRequest(
    securityProfileName: CreateSecurityProfileName,
    description: Optional[SecurityProfileDescription] = Optional.Absent,
    permissions: Optional[Iterable[SecurityProfilePermission]] =
      Optional.Absent,
    instanceId: InstanceId,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    allowedAccessControlTags: Optional[
      Map[SecurityProfilePolicyKey, SecurityProfilePolicyValue]
    ] = Optional.Absent,
    tagRestrictedResources: Optional[Iterable[TagRestrictedResourceName]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateSecurityProfileRequest = {
    import CreateSecurityProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateSecurityProfileRequest
      .builder()
      .securityProfileName(
        CreateSecurityProfileName.unwrap(securityProfileName): java.lang.String
      )
      .optionallyWith(
        description.map(value =>
          SecurityProfileDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        permissions.map(value =>
          value.map { item =>
            SecurityProfilePermission.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.permissions)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        allowedAccessControlTags.map(value =>
          value
            .map({ case (key, value) =>
              (SecurityProfilePolicyKey
                .unwrap(key): java.lang.String) -> (SecurityProfilePolicyValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.allowedAccessControlTags)
      .optionallyWith(
        tagRestrictedResources.map(value =>
          value.map { item =>
            TagRestrictedResourceName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tagRestrictedResources)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateSecurityProfileRequest.ReadOnly =
    zio.aws.connect.model.CreateSecurityProfileRequest.wrap(buildAwsValue())
}
object CreateSecurityProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateSecurityProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateSecurityProfileRequest =
      zio.aws.connect.model.CreateSecurityProfileRequest(
        securityProfileName,
        description.map(value => value),
        permissions.map(value => value),
        instanceId,
        tags.map(value => value),
        allowedAccessControlTags.map(value => value),
        tagRestrictedResources.map(value => value)
      )
    def securityProfileName: CreateSecurityProfileName
    def description: Optional[SecurityProfileDescription]
    def permissions: Optional[List[SecurityProfilePermission]]
    def instanceId: InstanceId
    def tags: Optional[Map[TagKey, TagValue]]
    def allowedAccessControlTags
        : Optional[Map[SecurityProfilePolicyKey, SecurityProfilePolicyValue]]
    def tagRestrictedResources: Optional[List[TagRestrictedResourceName]]
    def getSecurityProfileName: ZIO[Any, Nothing, CreateSecurityProfileName] =
      ZIO.succeed(securityProfileName)
    def getDescription: ZIO[Any, AwsError, SecurityProfileDescription] =
      AwsError.unwrapOptionField("description", description)
    def getPermissions: ZIO[Any, AwsError, List[SecurityProfilePermission]] =
      AwsError.unwrapOptionField("permissions", permissions)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAllowedAccessControlTags: ZIO[Any, AwsError, Map[
      SecurityProfilePolicyKey,
      SecurityProfilePolicyValue
    ]] = AwsError.unwrapOptionField(
      "allowedAccessControlTags",
      allowedAccessControlTags
    )
    def getTagRestrictedResources
        : ZIO[Any, AwsError, List[TagRestrictedResourceName]] = AwsError
      .unwrapOptionField("tagRestrictedResources", tagRestrictedResources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateSecurityProfileRequest
  ) extends zio.aws.connect.model.CreateSecurityProfileRequest.ReadOnly {
    override val securityProfileName: CreateSecurityProfileName =
      zio.aws.connect.model.primitives
        .CreateSecurityProfileName(impl.securityProfileName())
    override val description: Optional[SecurityProfileDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.connect.model.primitives.SecurityProfileDescription(value)
        )
    override val permissions: Optional[List[SecurityProfilePermission]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.primitives.SecurityProfilePermission(item)
          }.toList
        )
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val allowedAccessControlTags
        : Optional[Map[SecurityProfilePolicyKey, SecurityProfilePolicyValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowedAccessControlTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.connect.model.primitives.SecurityProfilePolicyKey(
                key
              ) -> zio.aws.connect.model.primitives
                .SecurityProfilePolicyValue(value)
            })
            .toMap
        )
    override val tagRestrictedResources
        : Optional[List[TagRestrictedResourceName]] = zio.aws.core.internal
      .optionalFromNullable(impl.tagRestrictedResources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.connect.model.primitives.TagRestrictedResourceName(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateSecurityProfileRequest
  ): zio.aws.connect.model.CreateSecurityProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
