package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ARN, SecurityProfileId}
import scala.jdk.CollectionConverters._
final case class CreateSecurityProfileResponse(
    securityProfileId: Optional[SecurityProfileId] = Optional.Absent,
    securityProfileArn: Optional[ARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateSecurityProfileResponse = {
    import CreateSecurityProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateSecurityProfileResponse
      .builder()
      .optionallyWith(
        securityProfileId.map(value =>
          SecurityProfileId.unwrap(value): java.lang.String
        )
      )(_.securityProfileId)
      .optionallyWith(
        securityProfileArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.securityProfileArn)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateSecurityProfileResponse.ReadOnly =
    zio.aws.connect.model.CreateSecurityProfileResponse.wrap(buildAwsValue())
}
object CreateSecurityProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateSecurityProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateSecurityProfileResponse =
      zio.aws.connect.model.CreateSecurityProfileResponse(
        securityProfileId.map(value => value),
        securityProfileArn.map(value => value)
      )
    def securityProfileId: Optional[SecurityProfileId]
    def securityProfileArn: Optional[ARN]
    def getSecurityProfileId: ZIO[Any, AwsError, SecurityProfileId] =
      AwsError.unwrapOptionField("securityProfileId", securityProfileId)
    def getSecurityProfileArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("securityProfileArn", securityProfileArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateSecurityProfileResponse
  ) extends zio.aws.connect.model.CreateSecurityProfileResponse.ReadOnly {
    override val securityProfileId: Optional[SecurityProfileId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityProfileId())
        .map(value => zio.aws.connect.model.primitives.SecurityProfileId(value))
    override val securityProfileArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.securityProfileArn())
      .map(value => zio.aws.connect.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateSecurityProfileResponse
  ): zio.aws.connect.model.CreateSecurityProfileResponse.ReadOnly = new Wrapper(
    impl
  )
}
