package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{TaskTemplateArn, TaskTemplateId}
import scala.jdk.CollectionConverters._
final case class CreateTaskTemplateResponse(
    id: TaskTemplateId,
    arn: TaskTemplateArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateTaskTemplateResponse = {
    import CreateTaskTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateTaskTemplateResponse
      .builder()
      .id(TaskTemplateId.unwrap(id): java.lang.String)
      .arn(TaskTemplateArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateTaskTemplateResponse.ReadOnly =
    zio.aws.connect.model.CreateTaskTemplateResponse.wrap(buildAwsValue())
}
object CreateTaskTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateTaskTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateTaskTemplateResponse =
      zio.aws.connect.model.CreateTaskTemplateResponse(id, arn)
    def id: TaskTemplateId
    def arn: TaskTemplateArn
    def getId: ZIO[Any, Nothing, TaskTemplateId] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, TaskTemplateArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateTaskTemplateResponse
  ) extends zio.aws.connect.model.CreateTaskTemplateResponse.ReadOnly {
    override val id: TaskTemplateId =
      zio.aws.connect.model.primitives.TaskTemplateId(impl.id())
    override val arn: TaskTemplateArn =
      zio.aws.connect.model.primitives.TaskTemplateArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateTaskTemplateResponse
  ): zio.aws.connect.model.CreateTaskTemplateResponse.ReadOnly = new Wrapper(
    impl
  )
}
