package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  Name128,
  TagValue,
  InstanceIdOrArn,
  ClientToken,
  Description250,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateTrafficDistributionGroupRequest(
    name: Name128,
    description: Optional[Description250] = Optional.Absent,
    instanceId: InstanceIdOrArn,
    clientToken: Optional[ClientToken] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateTrafficDistributionGroupRequest = {
    import CreateTrafficDistributionGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateTrafficDistributionGroupRequest
      .builder()
      .name(Name128.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description250.unwrap(value): java.lang.String)
      )(_.description)
      .instanceId(InstanceIdOrArn.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.CreateTrafficDistributionGroupRequest.ReadOnly =
    zio.aws.connect.model.CreateTrafficDistributionGroupRequest
      .wrap(buildAwsValue())
}
object CreateTrafficDistributionGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateTrafficDistributionGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.CreateTrafficDistributionGroupRequest =
      zio.aws.connect.model.CreateTrafficDistributionGroupRequest(
        name,
        description.map(value => value),
        instanceId,
        clientToken.map(value => value),
        tags.map(value => value)
      )
    def name: Name128
    def description: Optional[Description250]
    def instanceId: InstanceIdOrArn
    def clientToken: Optional[ClientToken]
    def tags: Optional[Map[TagKey, TagValue]]
    def getName: ZIO[Any, Nothing, Name128] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description250] =
      AwsError.unwrapOptionField("description", description)
    def getInstanceId: ZIO[Any, Nothing, InstanceIdOrArn] =
      ZIO.succeed(instanceId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateTrafficDistributionGroupRequest
  ) extends zio.aws.connect.model.CreateTrafficDistributionGroupRequest.ReadOnly {
    override val name: Name128 =
      zio.aws.connect.model.primitives.Name128(impl.name())
    override val description: Optional[Description250] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.connect.model.primitives.Description250(value))
    override val instanceId: InstanceIdOrArn =
      zio.aws.connect.model.primitives.InstanceIdOrArn(impl.instanceId())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.connect.model.primitives.ClientToken(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateTrafficDistributionGroupRequest
  ): zio.aws.connect.model.CreateTrafficDistributionGroupRequest.ReadOnly =
    new Wrapper(impl)
}
