package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  TagValue,
  TagKey,
  IntegrationAssociationId,
  InstanceId
}
import scala.jdk.CollectionConverters._
final case class CreateUseCaseRequest(
    instanceId: InstanceId,
    integrationAssociationId: IntegrationAssociationId,
    useCaseType: zio.aws.connect.model.UseCaseType,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateUseCaseRequest = {
    import CreateUseCaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateUseCaseRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .integrationAssociationId(
        IntegrationAssociationId.unwrap(
          integrationAssociationId
        ): java.lang.String
      )
      .useCaseType(useCaseType.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateUseCaseRequest.ReadOnly =
    zio.aws.connect.model.CreateUseCaseRequest.wrap(buildAwsValue())
}
object CreateUseCaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateUseCaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateUseCaseRequest =
      zio.aws.connect.model.CreateUseCaseRequest(
        instanceId,
        integrationAssociationId,
        useCaseType,
        tags.map(value => value)
      )
    def instanceId: InstanceId
    def integrationAssociationId: IntegrationAssociationId
    def useCaseType: zio.aws.connect.model.UseCaseType
    def tags: Optional[Map[TagKey, TagValue]]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getIntegrationAssociationId
        : ZIO[Any, Nothing, IntegrationAssociationId] =
      ZIO.succeed(integrationAssociationId)
    def getUseCaseType: ZIO[Any, Nothing, zio.aws.connect.model.UseCaseType] =
      ZIO.succeed(useCaseType)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateUseCaseRequest
  ) extends zio.aws.connect.model.CreateUseCaseRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val integrationAssociationId: IntegrationAssociationId =
      zio.aws.connect.model.primitives
        .IntegrationAssociationId(impl.integrationAssociationId())
    override val useCaseType: zio.aws.connect.model.UseCaseType =
      zio.aws.connect.model.UseCaseType.wrap(impl.useCaseType())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateUseCaseRequest
  ): zio.aws.connect.model.CreateUseCaseRequest.ReadOnly = new Wrapper(impl)
}
