package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  InstanceId,
  TagValue,
  HierarchyGroupId,
  HierarchyGroupName,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateUserHierarchyGroupRequest(
    name: HierarchyGroupName,
    parentGroupId: Optional[HierarchyGroupId] = Optional.Absent,
    instanceId: InstanceId,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateUserHierarchyGroupRequest = {
    import CreateUserHierarchyGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateUserHierarchyGroupRequest
      .builder()
      .name(HierarchyGroupName.unwrap(name): java.lang.String)
      .optionallyWith(
        parentGroupId.map(value =>
          HierarchyGroupId.unwrap(value): java.lang.String
        )
      )(_.parentGroupId)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.CreateUserHierarchyGroupRequest.ReadOnly =
    zio.aws.connect.model.CreateUserHierarchyGroupRequest.wrap(buildAwsValue())
}
object CreateUserHierarchyGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateUserHierarchyGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateUserHierarchyGroupRequest =
      zio.aws.connect.model.CreateUserHierarchyGroupRequest(
        name,
        parentGroupId.map(value => value),
        instanceId,
        tags.map(value => value)
      )
    def name: HierarchyGroupName
    def parentGroupId: Optional[HierarchyGroupId]
    def instanceId: InstanceId
    def tags: Optional[Map[TagKey, TagValue]]
    def getName: ZIO[Any, Nothing, HierarchyGroupName] = ZIO.succeed(name)
    def getParentGroupId: ZIO[Any, AwsError, HierarchyGroupId] =
      AwsError.unwrapOptionField("parentGroupId", parentGroupId)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateUserHierarchyGroupRequest
  ) extends zio.aws.connect.model.CreateUserHierarchyGroupRequest.ReadOnly {
    override val name: HierarchyGroupName =
      zio.aws.connect.model.primitives.HierarchyGroupName(impl.name())
    override val parentGroupId: Optional[HierarchyGroupId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parentGroupId())
        .map(value => zio.aws.connect.model.primitives.HierarchyGroupId(value))
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateUserHierarchyGroupRequest
  ): zio.aws.connect.model.CreateUserHierarchyGroupRequest.ReadOnly =
    new Wrapper(impl)
}
