package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  TagValue,
  ViewsInstanceId,
  ViewsClientToken,
  ViewName,
  ViewDescription,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateViewRequest(
    instanceId: ViewsInstanceId,
    clientToken: Optional[ViewsClientToken] = Optional.Absent,
    status: zio.aws.connect.model.ViewStatus,
    content: zio.aws.connect.model.ViewInputContent,
    description: Optional[ViewDescription] = Optional.Absent,
    name: ViewName,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateViewRequest = {
    import CreateViewRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateViewRequest
      .builder()
      .instanceId(ViewsInstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        clientToken.map(value =>
          ViewsClientToken.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .status(status.unwrap)
      .content(content.buildAwsValue())
      .optionallyWith(
        description.map(value =>
          ViewDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .name(ViewName.unwrap(name): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateViewRequest.ReadOnly =
    zio.aws.connect.model.CreateViewRequest.wrap(buildAwsValue())
}
object CreateViewRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateViewRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateViewRequest =
      zio.aws.connect.model.CreateViewRequest(
        instanceId,
        clientToken.map(value => value),
        status,
        content.asEditable,
        description.map(value => value),
        name,
        tags.map(value => value)
      )
    def instanceId: ViewsInstanceId
    def clientToken: Optional[ViewsClientToken]
    def status: zio.aws.connect.model.ViewStatus
    def content: zio.aws.connect.model.ViewInputContent.ReadOnly
    def description: Optional[ViewDescription]
    def name: ViewName
    def tags: Optional[Map[TagKey, TagValue]]
    def getInstanceId: ZIO[Any, Nothing, ViewsInstanceId] =
      ZIO.succeed(instanceId)
    def getClientToken: ZIO[Any, AwsError, ViewsClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getStatus: ZIO[Any, Nothing, zio.aws.connect.model.ViewStatus] =
      ZIO.succeed(status)
    def getContent
        : ZIO[Any, Nothing, zio.aws.connect.model.ViewInputContent.ReadOnly] =
      ZIO.succeed(content)
    def getDescription: ZIO[Any, AwsError, ViewDescription] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, ViewName] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateViewRequest
  ) extends zio.aws.connect.model.CreateViewRequest.ReadOnly {
    override val instanceId: ViewsInstanceId =
      zio.aws.connect.model.primitives.ViewsInstanceId(impl.instanceId())
    override val clientToken: Optional[ViewsClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.connect.model.primitives.ViewsClientToken(value))
    override val status: zio.aws.connect.model.ViewStatus =
      zio.aws.connect.model.ViewStatus.wrap(impl.status())
    override val content: zio.aws.connect.model.ViewInputContent.ReadOnly =
      zio.aws.connect.model.ViewInputContent.wrap(impl.content())
    override val description: Optional[ViewDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.connect.model.primitives.ViewDescription(value))
    override val name: ViewName =
      zio.aws.connect.model.primitives.ViewName(impl.name())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.connect.model.primitives
              .TagKey(key) -> zio.aws.connect.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateViewRequest
  ): zio.aws.connect.model.CreateViewRequest.ReadOnly = new Wrapper(impl)
}
