package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateViewResponse(
    view: Optional[zio.aws.connect.model.View] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateViewResponse = {
    import CreateViewResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateViewResponse
      .builder()
      .optionallyWith(view.map(value => value.buildAwsValue()))(_.view)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateViewResponse.ReadOnly =
    zio.aws.connect.model.CreateViewResponse.wrap(buildAwsValue())
}
object CreateViewResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateViewResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateViewResponse =
      zio.aws.connect.model
        .CreateViewResponse(view.map(value => value.asEditable))
    def view: Optional[zio.aws.connect.model.View.ReadOnly]
    def getView: ZIO[Any, AwsError, zio.aws.connect.model.View.ReadOnly] =
      AwsError.unwrapOptionField("view", view)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateViewResponse
  ) extends zio.aws.connect.model.CreateViewResponse.ReadOnly {
    override val view: Optional[zio.aws.connect.model.View.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.view())
        .map(value => zio.aws.connect.model.View.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateViewResponse
  ): zio.aws.connect.model.CreateViewResponse.ReadOnly = new Wrapper(impl)
}
