package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{
  ViewContentSha256,
  ViewDescription,
  ViewId,
  ViewsInstanceId
}
import scala.jdk.CollectionConverters._
final case class CreateViewVersionRequest(
    instanceId: ViewsInstanceId,
    viewId: ViewId,
    versionDescription: Optional[ViewDescription] = Optional.Absent,
    viewContentSha256: Optional[ViewContentSha256] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CreateViewVersionRequest = {
    import CreateViewVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CreateViewVersionRequest
      .builder()
      .instanceId(ViewsInstanceId.unwrap(instanceId): java.lang.String)
      .viewId(ViewId.unwrap(viewId): java.lang.String)
      .optionallyWith(
        versionDescription.map(value =>
          ViewDescription.unwrap(value): java.lang.String
        )
      )(_.versionDescription)
      .optionallyWith(
        viewContentSha256.map(value =>
          ViewContentSha256.unwrap(value): java.lang.String
        )
      )(_.viewContentSha256)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CreateViewVersionRequest.ReadOnly =
    zio.aws.connect.model.CreateViewVersionRequest.wrap(buildAwsValue())
}
object CreateViewVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CreateViewVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CreateViewVersionRequest =
      zio.aws.connect.model.CreateViewVersionRequest(
        instanceId,
        viewId,
        versionDescription.map(value => value),
        viewContentSha256.map(value => value)
      )
    def instanceId: ViewsInstanceId
    def viewId: ViewId
    def versionDescription: Optional[ViewDescription]
    def viewContentSha256: Optional[ViewContentSha256]
    def getInstanceId: ZIO[Any, Nothing, ViewsInstanceId] =
      ZIO.succeed(instanceId)
    def getViewId: ZIO[Any, Nothing, ViewId] = ZIO.succeed(viewId)
    def getVersionDescription: ZIO[Any, AwsError, ViewDescription] =
      AwsError.unwrapOptionField("versionDescription", versionDescription)
    def getViewContentSha256: ZIO[Any, AwsError, ViewContentSha256] =
      AwsError.unwrapOptionField("viewContentSha256", viewContentSha256)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CreateViewVersionRequest
  ) extends zio.aws.connect.model.CreateViewVersionRequest.ReadOnly {
    override val instanceId: ViewsInstanceId =
      zio.aws.connect.model.primitives.ViewsInstanceId(impl.instanceId())
    override val viewId: ViewId =
      zio.aws.connect.model.primitives.ViewId(impl.viewId())
    override val versionDescription: Optional[ViewDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionDescription())
        .map(value => zio.aws.connect.model.primitives.ViewDescription(value))
    override val viewContentSha256: Optional[ViewContentSha256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.viewContentSha256())
        .map(value => zio.aws.connect.model.primitives.ViewContentSha256(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CreateViewVersionRequest
  ): zio.aws.connect.model.CreateViewVersionRequest.ReadOnly = new Wrapper(impl)
}
