package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CrossChannelBehavior(
    behaviorType: zio.aws.connect.model.BehaviorType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CrossChannelBehavior = {
    import CrossChannelBehavior.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CrossChannelBehavior
      .builder()
      .behaviorType(behaviorType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CrossChannelBehavior.ReadOnly =
    zio.aws.connect.model.CrossChannelBehavior.wrap(buildAwsValue())
}
object CrossChannelBehavior {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CrossChannelBehavior
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CrossChannelBehavior =
      zio.aws.connect.model.CrossChannelBehavior(behaviorType)
    def behaviorType: zio.aws.connect.model.BehaviorType
    def getBehaviorType: ZIO[Any, Nothing, zio.aws.connect.model.BehaviorType] =
      ZIO.succeed(behaviorType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CrossChannelBehavior
  ) extends zio.aws.connect.model.CrossChannelBehavior.ReadOnly {
    override val behaviorType: zio.aws.connect.model.BehaviorType =
      zio.aws.connect.model.BehaviorType.wrap(impl.behaviorType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CrossChannelBehavior
  ): zio.aws.connect.model.CrossChannelBehavior.ReadOnly = new Wrapper(impl)
}
