package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CurrentMetricResult(
    dimensions: Optional[zio.aws.connect.model.Dimensions] = Optional.Absent,
    collections: Optional[Iterable[zio.aws.connect.model.CurrentMetricData]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CurrentMetricResult = {
    import CurrentMetricResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CurrentMetricResult
      .builder()
      .optionallyWith(dimensions.map(value => value.buildAwsValue()))(
        _.dimensions
      )
      .optionallyWith(
        collections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.collections)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CurrentMetricResult.ReadOnly =
    zio.aws.connect.model.CurrentMetricResult.wrap(buildAwsValue())
}
object CurrentMetricResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CurrentMetricResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CurrentMetricResult =
      zio.aws.connect.model.CurrentMetricResult(
        dimensions.map(value => value.asEditable),
        collections.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dimensions: Optional[zio.aws.connect.model.Dimensions.ReadOnly]
    def collections
        : Optional[List[zio.aws.connect.model.CurrentMetricData.ReadOnly]]
    def getDimensions
        : ZIO[Any, AwsError, zio.aws.connect.model.Dimensions.ReadOnly] =
      AwsError.unwrapOptionField("dimensions", dimensions)
    def getCollections: ZIO[Any, AwsError, List[
      zio.aws.connect.model.CurrentMetricData.ReadOnly
    ]] = AwsError.unwrapOptionField("collections", collections)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CurrentMetricResult
  ) extends zio.aws.connect.model.CurrentMetricResult.ReadOnly {
    override val dimensions
        : Optional[zio.aws.connect.model.Dimensions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dimensions())
        .map(value => zio.aws.connect.model.Dimensions.wrap(value))
    override val collections
        : Optional[List[zio.aws.connect.model.CurrentMetricData.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.collections())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connect.model.CurrentMetricData.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CurrentMetricResult
  ): zio.aws.connect.model.CurrentMetricResult.ReadOnly = new Wrapper(impl)
}
