package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CurrentMetricSortCriteria(
    sortByMetric: Optional[zio.aws.connect.model.CurrentMetricName] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.connect.model.SortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.CurrentMetricSortCriteria = {
    import CurrentMetricSortCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.CurrentMetricSortCriteria
      .builder()
      .optionallyWith(sortByMetric.map(value => value.unwrap))(_.sortByMetric)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.CurrentMetricSortCriteria.ReadOnly =
    zio.aws.connect.model.CurrentMetricSortCriteria.wrap(buildAwsValue())
}
object CurrentMetricSortCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.CurrentMetricSortCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.CurrentMetricSortCriteria =
      zio.aws.connect.model.CurrentMetricSortCriteria(
        sortByMetric.map(value => value),
        sortOrder.map(value => value)
      )
    def sortByMetric: Optional[zio.aws.connect.model.CurrentMetricName]
    def sortOrder: Optional[zio.aws.connect.model.SortOrder]
    def getSortByMetric
        : ZIO[Any, AwsError, zio.aws.connect.model.CurrentMetricName] =
      AwsError.unwrapOptionField("sortByMetric", sortByMetric)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.connect.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.CurrentMetricSortCriteria
  ) extends zio.aws.connect.model.CurrentMetricSortCriteria.ReadOnly {
    override val sortByMetric
        : Optional[zio.aws.connect.model.CurrentMetricName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortByMetric())
        .map(value => zio.aws.connect.model.CurrentMetricName.wrap(value))
    override val sortOrder: Optional[zio.aws.connect.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.connect.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.CurrentMetricSortCriteria
  ): zio.aws.connect.model.CurrentMetricSortCriteria.ReadOnly = new Wrapper(
    impl
  )
}
