package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.connect.model.primitives.{ReferenceValue, ReferenceKey}
import scala.jdk.CollectionConverters._
final case class DateReference(
    name: Optional[ReferenceKey] = Optional.Absent,
    value: Optional[ReferenceValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DateReference = {
    import DateReference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DateReference
      .builder()
      .optionallyWith(
        name.map(value => ReferenceKey.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        value.map(value => ReferenceValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DateReference.ReadOnly =
    zio.aws.connect.model.DateReference.wrap(buildAwsValue())
}
object DateReference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DateReference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DateReference = zio.aws.connect.model
      .DateReference(name.map(value => value), value.map(value => value))
    def name: Optional[ReferenceKey]
    def value: Optional[ReferenceValue]
    def getName: ZIO[Any, AwsError, ReferenceKey] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, ReferenceValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DateReference
  ) extends zio.aws.connect.model.DateReference.ReadOnly {
    override val name: Optional[ReferenceKey] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connect.model.primitives.ReferenceKey(value))
    override val value: Optional[ReferenceValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.connect.model.primitives.ReferenceValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DateReference
  ): zio.aws.connect.model.DateReference.ReadOnly = new Wrapper(impl)
}
