package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{ResourceId, InstanceId}
import scala.jdk.CollectionConverters._
final case class DeleteContactEvaluationRequest(
    instanceId: InstanceId,
    evaluationId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DeleteContactEvaluationRequest = {
    import DeleteContactEvaluationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DeleteContactEvaluationRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .evaluationId(ResourceId.unwrap(evaluationId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.DeleteContactEvaluationRequest.ReadOnly =
    zio.aws.connect.model.DeleteContactEvaluationRequest.wrap(buildAwsValue())
}
object DeleteContactEvaluationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DeleteContactEvaluationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DeleteContactEvaluationRequest =
      zio.aws.connect.model
        .DeleteContactEvaluationRequest(instanceId, evaluationId)
    def instanceId: InstanceId
    def evaluationId: ResourceId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getEvaluationId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(evaluationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DeleteContactEvaluationRequest
  ) extends zio.aws.connect.model.DeleteContactEvaluationRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val evaluationId: ResourceId =
      zio.aws.connect.model.primitives.ResourceId(impl.evaluationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DeleteContactEvaluationRequest
  ): zio.aws.connect.model.DeleteContactEvaluationRequest.ReadOnly =
    new Wrapper(impl)
}
