package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{ContactFlowId, InstanceId}
import scala.jdk.CollectionConverters._
final case class DeleteContactFlowRequest(
    instanceId: InstanceId,
    contactFlowId: ContactFlowId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DeleteContactFlowRequest = {
    import DeleteContactFlowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DeleteContactFlowRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .contactFlowId(ContactFlowId.unwrap(contactFlowId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DeleteContactFlowRequest.ReadOnly =
    zio.aws.connect.model.DeleteContactFlowRequest.wrap(buildAwsValue())
}
object DeleteContactFlowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DeleteContactFlowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DeleteContactFlowRequest =
      zio.aws.connect.model.DeleteContactFlowRequest(instanceId, contactFlowId)
    def instanceId: InstanceId
    def contactFlowId: ContactFlowId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getContactFlowId: ZIO[Any, Nothing, ContactFlowId] =
      ZIO.succeed(contactFlowId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DeleteContactFlowRequest
  ) extends zio.aws.connect.model.DeleteContactFlowRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val contactFlowId: ContactFlowId =
      zio.aws.connect.model.primitives.ContactFlowId(impl.contactFlowId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DeleteContactFlowRequest
  ): zio.aws.connect.model.DeleteContactFlowRequest.ReadOnly = new Wrapper(impl)
}
