package zio.aws.connect.model
import zio.aws.connect.model.primitives.{VersionNumber, ResourceId, InstanceId}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DeleteEvaluationFormRequest(
    instanceId: InstanceId,
    evaluationFormId: ResourceId,
    evaluationFormVersion: Optional[VersionNumber] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DeleteEvaluationFormRequest = {
    import DeleteEvaluationFormRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DeleteEvaluationFormRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .evaluationFormId(ResourceId.unwrap(evaluationFormId): java.lang.String)
      .optionallyWith(
        evaluationFormVersion.map(value => VersionNumber.unwrap(value): Integer)
      )(_.evaluationFormVersion)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DeleteEvaluationFormRequest.ReadOnly =
    zio.aws.connect.model.DeleteEvaluationFormRequest.wrap(buildAwsValue())
}
object DeleteEvaluationFormRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DeleteEvaluationFormRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DeleteEvaluationFormRequest =
      zio.aws.connect.model.DeleteEvaluationFormRequest(
        instanceId,
        evaluationFormId,
        evaluationFormVersion.map(value => value)
      )
    def instanceId: InstanceId
    def evaluationFormId: ResourceId
    def evaluationFormVersion: Optional[VersionNumber]
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getEvaluationFormId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(evaluationFormId)
    def getEvaluationFormVersion: ZIO[Any, AwsError, VersionNumber] =
      AwsError.unwrapOptionField("evaluationFormVersion", evaluationFormVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DeleteEvaluationFormRequest
  ) extends zio.aws.connect.model.DeleteEvaluationFormRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val evaluationFormId: ResourceId =
      zio.aws.connect.model.primitives.ResourceId(impl.evaluationFormId())
    override val evaluationFormVersion: Optional[VersionNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationFormVersion())
        .map(value => zio.aws.connect.model.primitives.VersionNumber(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DeleteEvaluationFormRequest
  ): zio.aws.connect.model.DeleteEvaluationFormRequest.ReadOnly = new Wrapper(
    impl
  )
}
