package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.InstanceId
import scala.jdk.CollectionConverters._
final case class DeleteInstanceRequest(instanceId: InstanceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DeleteInstanceRequest = {
    import DeleteInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DeleteInstanceRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DeleteInstanceRequest.ReadOnly =
    zio.aws.connect.model.DeleteInstanceRequest.wrap(buildAwsValue())
}
object DeleteInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DeleteInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DeleteInstanceRequest =
      zio.aws.connect.model.DeleteInstanceRequest(instanceId)
    def instanceId: InstanceId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DeleteInstanceRequest
  ) extends zio.aws.connect.model.DeleteInstanceRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DeleteInstanceRequest
  ): zio.aws.connect.model.DeleteInstanceRequest.ReadOnly = new Wrapper(impl)
}
