package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{PromptId, InstanceId}
import scala.jdk.CollectionConverters._
final case class DeletePromptRequest(
    instanceId: InstanceId,
    promptId: PromptId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DeletePromptRequest = {
    import DeletePromptRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DeletePromptRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .promptId(PromptId.unwrap(promptId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DeletePromptRequest.ReadOnly =
    zio.aws.connect.model.DeletePromptRequest.wrap(buildAwsValue())
}
object DeletePromptRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DeletePromptRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DeletePromptRequest =
      zio.aws.connect.model.DeletePromptRequest(instanceId, promptId)
    def instanceId: InstanceId
    def promptId: PromptId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getPromptId: ZIO[Any, Nothing, PromptId] = ZIO.succeed(promptId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DeletePromptRequest
  ) extends zio.aws.connect.model.DeletePromptRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val promptId: PromptId =
      zio.aws.connect.model.primitives.PromptId(impl.promptId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DeletePromptRequest
  ): zio.aws.connect.model.DeletePromptRequest.ReadOnly = new Wrapper(impl)
}
