package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{QueueId, InstanceId}
import scala.jdk.CollectionConverters._
final case class DeleteQueueRequest(instanceId: InstanceId, queueId: QueueId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DeleteQueueRequest = {
    import DeleteQueueRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DeleteQueueRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .queueId(QueueId.unwrap(queueId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DeleteQueueRequest.ReadOnly =
    zio.aws.connect.model.DeleteQueueRequest.wrap(buildAwsValue())
}
object DeleteQueueRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DeleteQueueRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DeleteQueueRequest =
      zio.aws.connect.model.DeleteQueueRequest(instanceId, queueId)
    def instanceId: InstanceId
    def queueId: QueueId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getQueueId: ZIO[Any, Nothing, QueueId] = ZIO.succeed(queueId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DeleteQueueRequest
  ) extends zio.aws.connect.model.DeleteQueueRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val queueId: QueueId =
      zio.aws.connect.model.primitives.QueueId(impl.queueId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DeleteQueueRequest
  ): zio.aws.connect.model.DeleteQueueRequest.ReadOnly = new Wrapper(impl)
}
