package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{RoutingProfileId, InstanceId}
import scala.jdk.CollectionConverters._
final case class DeleteRoutingProfileRequest(
    instanceId: InstanceId,
    routingProfileId: RoutingProfileId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DeleteRoutingProfileRequest = {
    import DeleteRoutingProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DeleteRoutingProfileRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .routingProfileId(
        RoutingProfileId.unwrap(routingProfileId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DeleteRoutingProfileRequest.ReadOnly =
    zio.aws.connect.model.DeleteRoutingProfileRequest.wrap(buildAwsValue())
}
object DeleteRoutingProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DeleteRoutingProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DeleteRoutingProfileRequest =
      zio.aws.connect.model
        .DeleteRoutingProfileRequest(instanceId, routingProfileId)
    def instanceId: InstanceId
    def routingProfileId: RoutingProfileId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getRoutingProfileId: ZIO[Any, Nothing, RoutingProfileId] =
      ZIO.succeed(routingProfileId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DeleteRoutingProfileRequest
  ) extends zio.aws.connect.model.DeleteRoutingProfileRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val routingProfileId: RoutingProfileId =
      zio.aws.connect.model.primitives.RoutingProfileId(impl.routingProfileId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DeleteRoutingProfileRequest
  ): zio.aws.connect.model.DeleteRoutingProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
