package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{RuleId, InstanceId}
import scala.jdk.CollectionConverters._
final case class DeleteRuleRequest(instanceId: InstanceId, ruleId: RuleId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DeleteRuleRequest = {
    import DeleteRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DeleteRuleRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .ruleId(RuleId.unwrap(ruleId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DeleteRuleRequest.ReadOnly =
    zio.aws.connect.model.DeleteRuleRequest.wrap(buildAwsValue())
}
object DeleteRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DeleteRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DeleteRuleRequest =
      zio.aws.connect.model.DeleteRuleRequest(instanceId, ruleId)
    def instanceId: InstanceId
    def ruleId: RuleId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getRuleId: ZIO[Any, Nothing, RuleId] = ZIO.succeed(ruleId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DeleteRuleRequest
  ) extends zio.aws.connect.model.DeleteRuleRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val ruleId: RuleId =
      zio.aws.connect.model.primitives.RuleId(impl.ruleId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DeleteRuleRequest
  ): zio.aws.connect.model.DeleteRuleRequest.ReadOnly = new Wrapper(impl)
}
