package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{SecurityProfileId, InstanceId}
import scala.jdk.CollectionConverters._
final case class DeleteSecurityProfileRequest(
    instanceId: InstanceId,
    securityProfileId: SecurityProfileId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DeleteSecurityProfileRequest = {
    import DeleteSecurityProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DeleteSecurityProfileRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .securityProfileId(
        SecurityProfileId.unwrap(securityProfileId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DeleteSecurityProfileRequest.ReadOnly =
    zio.aws.connect.model.DeleteSecurityProfileRequest.wrap(buildAwsValue())
}
object DeleteSecurityProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DeleteSecurityProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DeleteSecurityProfileRequest =
      zio.aws.connect.model
        .DeleteSecurityProfileRequest(instanceId, securityProfileId)
    def instanceId: InstanceId
    def securityProfileId: SecurityProfileId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getSecurityProfileId: ZIO[Any, Nothing, SecurityProfileId] =
      ZIO.succeed(securityProfileId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DeleteSecurityProfileRequest
  ) extends zio.aws.connect.model.DeleteSecurityProfileRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val securityProfileId: SecurityProfileId =
      zio.aws.connect.model.primitives
        .SecurityProfileId(impl.securityProfileId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DeleteSecurityProfileRequest
  ): zio.aws.connect.model.DeleteSecurityProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
