package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{TaskTemplateId, InstanceId}
import scala.jdk.CollectionConverters._
final case class DeleteTaskTemplateRequest(
    instanceId: InstanceId,
    taskTemplateId: TaskTemplateId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DeleteTaskTemplateRequest = {
    import DeleteTaskTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DeleteTaskTemplateRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .taskTemplateId(TaskTemplateId.unwrap(taskTemplateId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DeleteTaskTemplateRequest.ReadOnly =
    zio.aws.connect.model.DeleteTaskTemplateRequest.wrap(buildAwsValue())
}
object DeleteTaskTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DeleteTaskTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DeleteTaskTemplateRequest =
      zio.aws.connect.model
        .DeleteTaskTemplateRequest(instanceId, taskTemplateId)
    def instanceId: InstanceId
    def taskTemplateId: TaskTemplateId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getTaskTemplateId: ZIO[Any, Nothing, TaskTemplateId] =
      ZIO.succeed(taskTemplateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DeleteTaskTemplateRequest
  ) extends zio.aws.connect.model.DeleteTaskTemplateRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val taskTemplateId: TaskTemplateId =
      zio.aws.connect.model.primitives.TaskTemplateId(impl.taskTemplateId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DeleteTaskTemplateRequest
  ): zio.aws.connect.model.DeleteTaskTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
