package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.TrafficDistributionGroupIdOrArn
import scala.jdk.CollectionConverters._
final case class DeleteTrafficDistributionGroupRequest(
    trafficDistributionGroupId: TrafficDistributionGroupIdOrArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DeleteTrafficDistributionGroupRequest = {
    import DeleteTrafficDistributionGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DeleteTrafficDistributionGroupRequest
      .builder()
      .trafficDistributionGroupId(
        TrafficDistributionGroupIdOrArn.unwrap(
          trafficDistributionGroupId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.connect.model.DeleteTrafficDistributionGroupRequest.ReadOnly =
    zio.aws.connect.model.DeleteTrafficDistributionGroupRequest
      .wrap(buildAwsValue())
}
object DeleteTrafficDistributionGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DeleteTrafficDistributionGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connect.model.DeleteTrafficDistributionGroupRequest =
      zio.aws.connect.model
        .DeleteTrafficDistributionGroupRequest(trafficDistributionGroupId)
    def trafficDistributionGroupId: TrafficDistributionGroupIdOrArn
    def getTrafficDistributionGroupId
        : ZIO[Any, Nothing, TrafficDistributionGroupIdOrArn] =
      ZIO.succeed(trafficDistributionGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DeleteTrafficDistributionGroupRequest
  ) extends zio.aws.connect.model.DeleteTrafficDistributionGroupRequest.ReadOnly {
    override val trafficDistributionGroupId: TrafficDistributionGroupIdOrArn =
      zio.aws.connect.model.primitives
        .TrafficDistributionGroupIdOrArn(impl.trafficDistributionGroupId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DeleteTrafficDistributionGroupRequest
  ): zio.aws.connect.model.DeleteTrafficDistributionGroupRequest.ReadOnly =
    new Wrapper(impl)
}
