package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{ViewId, ViewsInstanceId}
import scala.jdk.CollectionConverters._
final case class DeleteViewRequest(
    instanceId: ViewsInstanceId,
    viewId: ViewId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DeleteViewRequest = {
    import DeleteViewRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DeleteViewRequest
      .builder()
      .instanceId(ViewsInstanceId.unwrap(instanceId): java.lang.String)
      .viewId(ViewId.unwrap(viewId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DeleteViewRequest.ReadOnly =
    zio.aws.connect.model.DeleteViewRequest.wrap(buildAwsValue())
}
object DeleteViewRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DeleteViewRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DeleteViewRequest =
      zio.aws.connect.model.DeleteViewRequest(instanceId, viewId)
    def instanceId: ViewsInstanceId
    def viewId: ViewId
    def getInstanceId: ZIO[Any, Nothing, ViewsInstanceId] =
      ZIO.succeed(instanceId)
    def getViewId: ZIO[Any, Nothing, ViewId] = ZIO.succeed(viewId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DeleteViewRequest
  ) extends zio.aws.connect.model.DeleteViewRequest.ReadOnly {
    override val instanceId: ViewsInstanceId =
      zio.aws.connect.model.primitives.ViewsInstanceId(impl.instanceId())
    override val viewId: ViewId =
      zio.aws.connect.model.primitives.ViewId(impl.viewId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DeleteViewRequest
  ): zio.aws.connect.model.DeleteViewRequest.ReadOnly = new Wrapper(impl)
}
