package zio.aws.connect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{ViewVersion, ViewId, ViewsInstanceId}
import scala.jdk.CollectionConverters._
final case class DeleteViewVersionRequest(
    instanceId: ViewsInstanceId,
    viewId: ViewId,
    viewVersion: ViewVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DeleteViewVersionRequest = {
    import DeleteViewVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DeleteViewVersionRequest
      .builder()
      .instanceId(ViewsInstanceId.unwrap(instanceId): java.lang.String)
      .viewId(ViewId.unwrap(viewId): java.lang.String)
      .viewVersion(ViewVersion.unwrap(viewVersion): Integer)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DeleteViewVersionRequest.ReadOnly =
    zio.aws.connect.model.DeleteViewVersionRequest.wrap(buildAwsValue())
}
object DeleteViewVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DeleteViewVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DeleteViewVersionRequest =
      zio.aws.connect.model
        .DeleteViewVersionRequest(instanceId, viewId, viewVersion)
    def instanceId: ViewsInstanceId
    def viewId: ViewId
    def viewVersion: ViewVersion
    def getInstanceId: ZIO[Any, Nothing, ViewsInstanceId] =
      ZIO.succeed(instanceId)
    def getViewId: ZIO[Any, Nothing, ViewId] = ZIO.succeed(viewId)
    def getViewVersion: ZIO[Any, Nothing, ViewVersion] =
      ZIO.succeed(viewVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DeleteViewVersionRequest
  ) extends zio.aws.connect.model.DeleteViewVersionRequest.ReadOnly {
    override val instanceId: ViewsInstanceId =
      zio.aws.connect.model.primitives.ViewsInstanceId(impl.instanceId())
    override val viewId: ViewId =
      zio.aws.connect.model.primitives.ViewId(impl.viewId())
    override val viewVersion: ViewVersion =
      zio.aws.connect.model.primitives.ViewVersion(impl.viewVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DeleteViewVersionRequest
  ): zio.aws.connect.model.DeleteViewVersionRequest.ReadOnly = new Wrapper(impl)
}
