package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{VocabularyId, InstanceId}
import scala.jdk.CollectionConverters._
final case class DeleteVocabularyRequest(
    instanceId: InstanceId,
    vocabularyId: VocabularyId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DeleteVocabularyRequest = {
    import DeleteVocabularyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DeleteVocabularyRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .vocabularyId(VocabularyId.unwrap(vocabularyId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DeleteVocabularyRequest.ReadOnly =
    zio.aws.connect.model.DeleteVocabularyRequest.wrap(buildAwsValue())
}
object DeleteVocabularyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DeleteVocabularyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DeleteVocabularyRequest =
      zio.aws.connect.model.DeleteVocabularyRequest(instanceId, vocabularyId)
    def instanceId: InstanceId
    def vocabularyId: VocabularyId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getVocabularyId: ZIO[Any, Nothing, VocabularyId] =
      ZIO.succeed(vocabularyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DeleteVocabularyRequest
  ) extends zio.aws.connect.model.DeleteVocabularyRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.connect.model.primitives.InstanceId(impl.instanceId())
    override val vocabularyId: VocabularyId =
      zio.aws.connect.model.primitives.VocabularyId(impl.vocabularyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DeleteVocabularyRequest
  ): zio.aws.connect.model.DeleteVocabularyRequest.ReadOnly = new Wrapper(impl)
}
