package zio.aws.connect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.connect.model.primitives.{VocabularyId, ARN}
import scala.jdk.CollectionConverters._
final case class DeleteVocabularyResponse(
    vocabularyArn: ARN,
    vocabularyId: VocabularyId,
    state: zio.aws.connect.model.VocabularyState
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connect.model.DeleteVocabularyResponse = {
    import DeleteVocabularyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connect.model.DeleteVocabularyResponse
      .builder()
      .vocabularyArn(ARN.unwrap(vocabularyArn): java.lang.String)
      .vocabularyId(VocabularyId.unwrap(vocabularyId): java.lang.String)
      .state(state.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.connect.model.DeleteVocabularyResponse.ReadOnly =
    zio.aws.connect.model.DeleteVocabularyResponse.wrap(buildAwsValue())
}
object DeleteVocabularyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connect.model.DeleteVocabularyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connect.model.DeleteVocabularyResponse =
      zio.aws.connect.model
        .DeleteVocabularyResponse(vocabularyArn, vocabularyId, state)
    def vocabularyArn: ARN
    def vocabularyId: VocabularyId
    def state: zio.aws.connect.model.VocabularyState
    def getVocabularyArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(vocabularyArn)
    def getVocabularyId: ZIO[Any, Nothing, VocabularyId] =
      ZIO.succeed(vocabularyId)
    def getState: ZIO[Any, Nothing, zio.aws.connect.model.VocabularyState] =
      ZIO.succeed(state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connect.model.DeleteVocabularyResponse
  ) extends zio.aws.connect.model.DeleteVocabularyResponse.ReadOnly {
    override val vocabularyArn: ARN =
      zio.aws.connect.model.primitives.ARN(impl.vocabularyArn())
    override val vocabularyId: VocabularyId =
      zio.aws.connect.model.primitives.VocabularyId(impl.vocabularyId())
    override val state: zio.aws.connect.model.VocabularyState =
      zio.aws.connect.model.VocabularyState.wrap(impl.state())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connect.model.DeleteVocabularyResponse
  ): zio.aws.connect.model.DeleteVocabularyResponse.ReadOnly = new Wrapper(impl)
}
